<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    set_time_limit(0);
    ob_implicit_flush(true);
    ob_end_flush();

    $archivo_estado = "ultimo_encontrado.txt";
    $numero_inicial = isset($_POST['numero']) && is_numeric($_POST['numero']) ? intval($_POST['numero']) : (
        file_exists($archivo_estado) ? intval(trim(file_get_contents($archivo_estado))) + 1 : 69000
    );

    $inicio = $numero_inicial;
    $base_url = "https://www.bomberosperu.gob.pe/resoluciones/rr/";
    $tiempo_limite = 60;
    $ultima_vez = time();
    $validos = [];
    $consecutivos_validos = 0;
    $modo_salto = false;

    echo "<pre style='color:lime; background:black; padding:20px; font-family:monospace;'>🚀 Iniciando búsqueda desde $inicio...\n";

    while (true) {
        $url = $base_url . $inicio . ".pdf";
        $headers = @get_headers($url);

        if ($headers && strpos($headers[0], '200 OK') !== false) {
            echo "✅ Encontrado: $url\n";
            echo "<script>window.open('$url', '_blank');</script>";
            $validos[] = $url;
            $ultima_vez = time();
            $consecutivos_validos++;

            file_put_contents($archivo_estado, $inicio);

            if ($consecutivos_validos >= 10 && !$modo_salto) {
                echo "⏩ ¡10 válidos consecutivos detectados! Saltando de 100...\n";
                $modo_salto = true;
            }
        } else {
            echo "❌ No encontrado: $url\n";
            $consecutivos_validos = 0;
            $modo_salto = false;
        }

        $inicio += $modo_salto ? 100 : 1;

        flush();
        sleep(1);

        if ((time() - $ultima_vez) >= $tiempo_limite) {
            echo "\n🛑 Tiempo sin hallazgos superado. Fin del escaneo.\n";
            break;
        }
    }

    echo "\n🔗 Últimos PDFs válidos encontrados:\n";
    $ultimos = array_slice($validos, -3);

    echo "<div style='margin-top:15px'>";
    foreach ($ultimos as $url) {
        echo "🟢 <a href='$url' target='_blank' style='color: #00ff00;'>$url</a><br>";
    }
    echo "</div></pre>";
    echo "<script>
        document.getElementById('reinicio').style.display = 'block';
    </script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Escáner Hacker de PDFs</title>
    <style>
        body {
            background: black;
            color: #00ff00;
            font-family: monospace;
            padding: 30px;
        }
        input[type='number'], button {
            background: black;
            color: lime;
            border: 2px solid lime;
            padding: 10px 15px;
            font-size: 16px;
            margin: 10px 0;
        }
        input[type='number'] {
            width: 200px;
        }
        a {
            color: #00ff00;
        }
        .panel {
            margin-top: 30px;
        }
    </style>
</head>
<body>
    <h1>🧠 Escáner Hacker de Resoluciones PDF</h1>
    <form method="post">
        <button type="submit">🚀 Iniciar búsqueda automática</button>
    </form>

    <div id="reinicio" class="panel" style="display:none;">
        <h3>🔁 ¿Buscar desde un número específico?</h3>
        <form method="post">
            <label for="numero">Empezar desde:</label><br>
            <input type="number" name="numero" id="numero" min="1" placeholder="Ej: 70000"><br>
            <button type="submit">🔍 Buscar desde número</button>
        </form>
    </div>
    
    
    <div class="panel">
    <h3>🔁 ¿Buscar desde un número específico?</h3>
    <form method="post">
        <label for="numero">Empezar desde:</label><br>
        <input type="number" name="numero" id="numero" min="1" placeholder="Ej: 70000"><br>
        <button type="submit">🔍 Buscar desde número</button>
    </form>
</div>

<?php
$ultimo_numero = file_exists("ultimo_encontrado.txt") ? trim(file_get_contents("ultimo_encontrado.txt")) : "Ninguno aún";
?>
<div style="margin-top: 30px; border-top: 1px dashed lime; padding-top: 10px;">
    <h3>📌 Último número PDF válido encontrado:</h3>
    <p style="font-size: 22px; color: #00ff00;">🧾 <?= $ultimo_numero ?></p>
</div>


</body>
</html>
